/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.database;

import java.sql.SQLException;
import org.apache.derby.iapi.db.PropertyInfo;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;

public abstract class UserUtility {
    public static final String READ_ACCESS_PERMISSION = "READ_ACCESS_PERMISSION";
    public static final String FULL_ACCESS_PERMISSION = "FULL_ACCESS_PERMISSION";

    public static final void add(String string, String string2) throws SQLException {
        block5: {
            TransactionController transactionController = ConnectionUtil.getCurrentLCC().getTransactionExecute();
            try {
                UserUtility.normalizeIdParam("userName", string);
                if (string2 == null) {
                    throw StandardException.newException("XCZ02.S", "permission", (Object)"null");
                }
                if (string2.equals(READ_ACCESS_PERMISSION)) {
                    String string3 = (String)((Object)transactionController.getProperty("derby.database.readOnlyAccessUsers"));
                    string3 = IdUtil.appendId(string, string3);
                    PropertyInfo.setDatabaseProperty("derby.database.readOnlyAccessUsers", string3);
                    break block5;
                }
                if (string2.equals(FULL_ACCESS_PERMISSION)) {
                    String string4 = (String)((Object)transactionController.getProperty("derby.database.fullAccessUsers"));
                    string4 = IdUtil.appendId(string, string4);
                    PropertyInfo.setDatabaseProperty("derby.database.fullAccessUsers", string4);
                    break block5;
                }
                throw StandardException.newException("XCZ00.S", string2);
            }
            catch (StandardException standardException) {
                throw PublicAPI.wrapStandardException(standardException);
            }
        }
    }

    public static final void set(String string, String string2) throws SQLException {
        UserUtility.drop(string);
        UserUtility.add(string, string2);
    }

    public static final void drop(String string) throws SQLException {
        block4: {
            TransactionController transactionController = ConnectionUtil.getCurrentLCC().getTransactionExecute();
            try {
                String string2 = UserUtility.normalizeIdParam("userName", string);
                String string3 = UserUtility.getPermission(string);
                if (string3 != null && string3.equals(READ_ACCESS_PERMISSION)) {
                    String string4 = (String)((Object)transactionController.getProperty("derby.database.readOnlyAccessUsers"));
                    String string5 = IdUtil.deleteId(string2, string4);
                    PropertyInfo.setDatabaseProperty("derby.database.readOnlyAccessUsers", string5);
                    break block4;
                }
                if (string3 != null && string3.equals(FULL_ACCESS_PERMISSION)) {
                    String string6 = (String)((Object)transactionController.getProperty("derby.database.fullAccessUsers"));
                    String string7 = IdUtil.deleteId(string2, string6);
                    PropertyInfo.setDatabaseProperty("derby.database.fullAccessUsers", string7);
                    break block4;
                }
                throw StandardException.newException("XCZ01.S", string);
            }
            catch (StandardException standardException) {
                throw PublicAPI.wrapStandardException(standardException);
            }
        }
    }

    public static final String getPermission(String string) throws SQLException {
        TransactionController transactionController = ConnectionUtil.getCurrentLCC().getTransactionExecute();
        try {
            String string2 = (String)((Object)transactionController.getProperty("derby.database.readOnlyAccessUsers"));
            String string3 = UserUtility.normalizeIdParam("userName", string);
            if (IdUtil.idOnList(string3, string2)) {
                return READ_ACCESS_PERMISSION;
            }
            string2 = (String)((Object)transactionController.getProperty("derby.database.fullAccessUsers"));
            if (IdUtil.idOnList(string3, string2)) {
                return FULL_ACCESS_PERMISSION;
            }
            return null;
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    private static String normalizeIdParam(String string, String string2) throws StandardException {
        if (string2 == null) {
            throw StandardException.newException("XCZ02.S", string, (Object)"null");
        }
        try {
            return IdUtil.parseId(string2);
        }
        catch (StandardException standardException) {
            throw StandardException.newException("XCZ02.S", standardException, (Object)string, (Object)string2);
        }
    }

    private UserUtility() {
    }
}

